/*
 * Decompiled with CFR 0.152.
 */
package com.ansat.autotool;

import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.core.BlockPos;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.AxeItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.PickaxeItem;
import net.minecraft.world.item.ShovelItem;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.client.event.InputEvent;
import net.minecraftforge.client.event.RegisterKeyMappingsEvent;
import net.minecraftforge.client.event.RenderGuiOverlayEvent;
import net.minecraftforge.client.gui.overlay.VanillaGuiOverlay;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.player.AttackEntityEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;

@Mod(value="autotool")
public class AutoToolMod {
    public static boolean enabled = true;
    private static long messageShowUntil = 0L;
    private static String messageText = "";
    private static final KeyMapping TOGGLE_KEY = new KeyMapping("key.autotool.toggle", 79, "key.categories.misc");

    public AutoToolMod() {
        MinecraftForge.EVENT_BUS.register((Object)this);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::registerKeys);
        MinecraftForge.EVENT_BUS.addListener(this::renderOverlay);
    }

    private void registerKeys(RegisterKeyMappingsEvent event) {
        event.register(TOGGLE_KEY);
    }

    @SubscribeEvent
    public void onKeyInput(InputEvent.Key event) {
        if (TOGGLE_KEY.m_90859_()) {
            enabled = !enabled;
            messageText = enabled ? "AutoTool: \u0412\u041a\u041b" : "AutoTool: \u0412\u042b\u041a\u041b";
            messageShowUntil = System.currentTimeMillis() + 3000L;
        }
    }

    @SubscribeEvent
    public void onLeftClickBlock(PlayerInteractEvent.LeftClickBlock event) {
        if (!enabled) {
            return;
        }
        Player player = event.getEntity();
        if (!player.m_9236_().m_5776_()) {
            return;
        }
        BlockPos pos = event.getPos();
        BlockState state = player.m_9236_().m_8055_(pos);
        Class<PickaxeItem> neededTool = null;
        if (state.m_204336_(BlockTags.f_144282_)) {
            neededTool = PickaxeItem.class;
        } else if (state.m_204336_(BlockTags.f_144283_)) {
            neededTool = ShovelItem.class;
        } else if (state.m_204336_(BlockTags.f_144280_)) {
            neededTool = AxeItem.class;
        }
        if (neededTool != null) {
            for (int slot = 0; slot < 9; ++slot) {
                ItemStack stack = player.m_150109_().m_8020_(slot);
                if (!neededTool.isInstance(stack.m_41720_())) continue;
                player.m_150109_().f_35977_ = slot;
                break;
            }
        }
    }

    @SubscribeEvent
    public void onAttackEntity(AttackEntityEvent event) {
        if (!enabled) {
            return;
        }
        Player player = event.getEntity();
        if (!player.m_9236_().m_5776_()) {
            return;
        }
        for (int slot = 0; slot < 9; ++slot) {
            ItemStack stack = player.m_150109_().m_8020_(slot);
            if (!(stack.m_41720_() instanceof SwordItem)) continue;
            player.m_150109_().f_35977_ = slot;
            break;
        }
    }

    public void renderOverlay(RenderGuiOverlayEvent.Post event) {
        if (event.getOverlay() != VanillaGuiOverlay.HOTBAR.type()) {
            return;
        }
        if (messageText.isEmpty() || System.currentTimeMillis() > messageShowUntil) {
            return;
        }
        Minecraft mc = Minecraft.m_91087_();
        Font font = mc.f_91062_;
        GuiGraphics guiGraphics = event.getGuiGraphics();
        int screenWidth = mc.m_91268_().m_85445_();
        int stringWidth = font.m_92895_(messageText);
        int x = (screenWidth - stringWidth) / 2;
        int y = mc.m_91268_().m_85446_() - 60;
        guiGraphics.m_280056_(font, messageText, x, y, 0xFFFFFF, true);
    }
}

